1 '
2 ' WSG GCL Gripping Cycle Example
3 '
4 '
5 Title "WSG GCL Gripping Cycle Example"
6 '
7 'Open connection to gripper
8 Open "COM4:" As #1
9 '
10 'Start of program. Check device type.
11 'Skip finger check for devices that don't offer
12 'a sensor port.
13 CallP "WSGDevType"
14 If M_StatusCode <> 0 Then Error 9010
15 If C_DevTypeStr = "WSG 25-064" Then *CheckState
16 If C_DevTypeStr = "WSG 70-110" Then *CheckState
17 '
18 'Check if finger 1 is WSG-FMF and if so, tare it
19 CallP "WSGFType", 0%
20 If M_StatusCode <> 0 Then Error 9010
21 If C_FingerTypeStr = "WSG-FMF" Then
22   CallP "WSGTare", 0%
23   If M_StatusCode <> 0 Then Error 9010
24 EndIf
25 '
26 'Check if finger 2 is WSG-FMF and if so, tare it
27 CallP "WSGFType", 1%
28 If M_StatusCode <> 0 Then Error 9010
29 If C_FingerTypeStr = "WSG-FMF" Then
30   CallP "WSGTare", 1%
31   If M_StatusCode <> 0 Then Error 9010
32 EndIf
33 '
34 'Check if gripper state is IDLE (0).
35 *CheckState
36 CallP "WSGGripState"
37 If M_StatusCode <> 0 Then Error 9010
38 If M_GripStateVal <> 0 Then
39   Error 9011
40 EndIf
41 If C_GripStateStr <> "GS_IDLE" Then
42   Error 9011
43 EndIf
44 '
45 'Execute homing procedure on gripper (outer homing)
46 CallP "WSGHome", 1%
47 If M_StatusCode <> 0 Then Error 9010
48 '
49 'Pre-position fingers to 40 mm at 100 mm/s
50 *Start
51 CallP "WSGMove", 40, 100
52 If M_StatusCode <> 0 Then Error 9010
53 '
54 'Grip at 20 mm with speed 100 mm/s and force 20 N
55 *Grip
56 CallP "WSGGrip", 20, 20, 100
57 If M_StatusCode = 0 Then *GripCheckState
58 If M_StatusCode = 18 Then *GripCheckState
59 Error 9010
60 '
61 'Check grip state after gripping
62 *GripCheckState
63 CallP "WSGGripState"
64 If M_StatusCode <> 0 Then Error 9010
65 If C_GripStateStr = "GS_HOLDING" Then *Release
66 If C_GripStateStr = "GS_NO_PART" Then *Release
67 Error 9012
68 '
69 'Release by 20 mm with speed 100 mm/s
70 *Release
71 CallP "WSGRelease", 20, 100
72 If M_StatusCode <> 0 Then Error 9010
73 '
74 'Check grip state after releasing
75 CallP "WSGGripState"
76 If M_StatusCode <> 0 Then Error 9010
77 If C_GripStateStr <> "GS_IDLE" Then Error 9012
78 '
79 'Close connection
80 CallP "WSGBye"			' Send BYE message
81 Dly 0.01 						' Wait to fix runtime error
82 Close #1						' Close connection
83 Dly 0.01						' Wait some time before returning
84 '
85 'End program
86 End
