1 '
2 ' This function reads out the WSG's current gripping
3 ' state using the GCL command language
4 '
5 'Initialize return status to 0
6 M_StatusCode = 0%
7 'Send command string
8 Print #1, "GRIPSTATE?"
9 'Read return message
10 Input #1, CRetVal$
11 'Expected return value: GRIPSTATE=...
12 MStrLen% = Len( CRetVal$ )
13 If ( Left$( CRetVal$, 10 ) = "GRIPSTATE=" ) And ( MStrLen% > 10% ) Then
14 	CSubStr$ = Mid$( CRetVal$, 11%, MStrLen% - 10% )
15 	M_GripStateVal = Val( CSubStr$ )
16   Select M_GripStateVal
17 		Case 0
18 			C_GripStateStr = "GS_IDLE"
19 			Break
20 		Case 1
21 			C_GripStateStr = "GS_GRIPPING"
22 			Break
23 		Case 2
24 			C_GripStateStr = "GS_NO_PART"
25 			Break
26 		Case 3
27 			C_GripStateStr = "GS_PART_LOST"
28 			Break
29 		Case 4
30 			C_GripStateStr = "GS_HOLDING"
31 			Break
32 		Case 5
33 			C_GripStateStr = "GS_RELEASING"
34 			Break
35 		Case 6
36 			C_GripStateStr = "GS_POSITIONING"
37 			Break
38 		Case 7
39 			C_GripStateStr = "GS_ERROR"
40 			Break
41 		Default
42 			Error 9002
43 			Break
44 	End Select
45 Else
46 	CallP "ParseErr", "GRIPSTATE", CRetVal$
47 EndIf
48 End
