1 '
2 'WSG GCL test sequence
3 '
4 '
5 Title "WSG GCL Test"
6 '
7 'Open connection to gripper
8 Open "COM4:" As #1		'Direct connection to gripper 192.168.1.20:1000
9 '
10 'Check if gripper is in fast stop state and acknowledge if necessary
11 CallP "WSGSysFlag", 12%
12 If M_StatusCode <> 0 Then Error 9010
13 If M_SysFlag = 1 Then
14   CallP "WSGFSAck"
15   If M_StatusCode <> 0 Then
16     Error 9010
17   EndIf
18 EndIf
19 '
20 ' Start of program. Check if gripper state is IDLE (0).
21 *Start
22 CallP "WSGGripState"
23 If M_StatusCode <> 0 Then Error 9010
24 If M_GripStateVal <> 0 Then
25   Error 9011
26 EndIf
27 If C_GripStateStr <> "GS_IDLE" Then
28   Error 9011
29 EndIf
30 '
31 'Check if finger 1 is WSG-FMF and if so, tare it
32 *GetFMF1
33 CallP "WSGFType", 0%
34 If M_StatusCode <> 0 Then Error 9010
35 If C_FingerTypeStr = "WSG-FMF" Then
36   CallP "WSGTare", 0%
37   If M_StatusCode <> 0 Then Error 9010
38 EndIf
39 '
40 'Check if finger 2 is WSG-FMF and if so, tare it
41 *GetFMF2
42 CallP "WSGFType", 1%
43 If M_StatusCode <> 0 Then Error 9010
44 If C_FingerTypeStr = "WSG-FMF" Then
45   CallP "WSGTare", 1%
46   If M_StatusCode <> 0 Then Error 9010
47 EndIf
48 '
49 'Execute homing procedure on gripper (inner homing)
50 *HomeInner
51 CallP "WSGHome", 0%
52 If M_StatusCode <> 0 Then Error 9010
53 '
54 'Execute homing procedure on gripper (outer homing)
55 *HomeOuter
56 CallP "WSGHome", 1%
57 If M_StatusCode <> 0 Then Error 9010
58 '
59 ' Pre-position fingers to 40 mm at 100 mm/s
60 *Move
61 CallP "WSGMove", 40, 100
62 If M_StatusCode <> 0 Then Error 9010
63 '
64 ' Grip at 20 mm with speed 100 mm/s and force 20 N
65 *Grip
66 CallP "WSGGrip", 20, 20, 100
67 If M_StatusCode = 0 Then *GripCheckState
68 If M_StatusCode = 18 Then *GripCheckState
69 Error 9010
70 '
71 ' Check grip state after gripping
72 *GripCheckState
73 CallP "WSGGripState"
74 If M_StatusCode <> 0 Then Error 9010
75 If C_GripStateStr = "GS_HOLDING" Then *Release
76 If C_GripStateStr = "GS_NO_PART" Then *Release
77 Error 9012
78 '
79 ' Release by 20 mm with speed 100 mm/s
80 *Release
81 CallP "WSGRelease", 20, 100
82 If M_StatusCode <> 0 Then Error 9010
83 '
84 'Check grip state after releasing
85 *RelCheckState
86 CallP "WSGGripState"
87 If M_StatusCode <> 0 Then Error 9010
88 If C_GripStateStr <> "GS_IDLE" Then Error 9012
89 '
90 'Trigger a FastStop
91 *FastStop
92 CallP "WSGFastStop"
93 If M_StatusCode <> 0 Then Error 9010
94 'Check if FastStop system flag is set
95 CallP "WSGSysFlag", 12%
96 If M_StatusCode <> 0 Then Error 9010
97 If M_SysFlag <> 1 Then Error 9013
98 '
99 'Acknowledge FastStop
100 *FSAck
101 CallP "WSGFSAck"
102 If M_StatusCode <> 0 Then Error 9010
103 CallP "WSGSysFlag", 12%
104 If M_StatusCode <> 0 Then Error 9010
105 If M_SysFlag <> 0 Then Error 9014
106 '
107 'Get Force
108 *GetForce
109 CallP "WSGForce"
110 If M_StatusCode <> 0 Then Error 9010
111 '
112 'Get Position
113 *GetPosition
114 CallP "WSGPosition"
115 If M_StatusCode <> 0 Then Error 9010
116 '
117 'Get speed
118 *GetSpeed
119 CallP "WSGSpeed"
120 If M_StatusCode <> 0 Then Error 9010
121 '
122 'Get temperature
123 *GetTemp
124 CallP "WSGTemp"
125 If M_StatusCode <> 0 Then Error 9010
126 '
127 'Close connection
128 *Bye
129 CallP "WSGBye"			' Send BYE message
130 Dly 0.01 						' Wait to fix runtime error
131 Close #1						' Close connection
132 Dly 0.01						' Wait some time before returning
133 '
134 'End program
135 End
